#include <mail/nwsmtp/src/big_ml/errors.h>
#include <mail/nwsmtp/src/blackbox/error_code.h>
#include <mail/nwsmtp/src/delivery/async/error_code.h>
#include <mail/nwsmtp/src/ml/client_impl.h>
#include <mail/nwsmtp/src/smtp_client/error_code.h>
#include <mail/nwsmtp/src/web/send_mail/error_code.h>
#include <mail/nwsmtp/src/types.h>

#include <gtest/gtest.h>
#include <gmock/gmock.h>

namespace {

using namespace testing;
using namespace NNwSmtp;
using EError = NWeb::NSendMail::EError;

struct TestErrors: TestWithParam<std::tuple<TErrorCode, EError>> {
};

TEST_P(TestErrors, test_equivalent_error_code) {
    EXPECT_TRUE(std::get<0>(GetParam()) == make_error_condition(std::get<1>(GetParam())));
}

INSTANTIATE_TEST_SUITE_P(
    test_equivalent_error_code,
    TestErrors,
    Values(
        std::make_tuple(
            make_error_code(NBlackBox::EError::BadKarma),
            EError::BadKarma
        ),
        std::make_tuple(
            make_error_code(NBlackBox::EError::TempBanUser),
            EError::TempBanUser
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::RpopAuthTempFail),
            EError::FailedToAuthSender
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::RpopAuthRejected),
            EError::FailedToAuthSender
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::AvirRejected),
            EError::Virus
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::MaliciousRejected),
            EError::StrongSpam
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::MaliciousDiscarded),
            EError::SendMessageDiscarded
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::AvirDiscarded),
            EError::SendMessageDiscarded
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::TooManyHeadersReject),
            EError::SendMessageFailed
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::DeliveryRejected),
            EError::SendMessageFailed
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::SenderIdRejected),
            EError::SendMessageFailed
        ),
        std::make_tuple(
            make_error_code(NNwSmtp::SmtpClient::EError::Rejected),
            EError::SendMessageFailed
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::DkimSignTempFail),
            EError::SendMessageTempFail
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::DeliveryTempFail),
            EError::SendMessageTempFail
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::RouteTempFail),
            EError::SendMessageTempFail
        ),
        std::make_tuple(
            make_error_code(SmtpClient::EError::TempFail),
            EError::SendMessageTempFail
        ),
        std::make_tuple(
            make_error_code(NBlackBox::EError::BbTempUserError),
            EError::SendMessageTempFail
        ),
        std::make_tuple(
            make_error_code(NBlackBox::EError::UserNotFound),
            EError::BadSender
        ),
        std::make_tuple(
            make_error_code(NBlackBox::EError::EmptySender),
            EError::BadSender
        ),
        std::make_tuple(
            make_error_code(NBlackBox::EError::UserBlocked),
            EError::BadSender
        ),
        std::make_tuple(
            make_error_code(NBlackBox::EError::UserBlocked),
            EError::BadRecipient
        ),
        std::make_tuple(
            make_error_code(NBlackBox::EError::UserNotFound),
            EError::BadRecipient
        ),
        std::make_tuple(
            make_error_code(NBigML::EErrorCode::EC_NOT_FOUND),
            EError::MLNotFound
        ),
        std::make_tuple(
            make_error_code(list_client_ec::NOT_FOUND),
            EError::MLNotFound
        ),
        std::make_tuple(
            make_error_code(NBigML::EErrorCode::EC_PERMISSION_DENIED),
            EError::MLPermissionDenied
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::SpamDiscarded),
            EError::SendMessageDiscarded
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::SpamRejected),
            EError::Spam
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::SoTempFail),
            EError::SendMessageTempFail
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::RfcFailRejected),
            EError::StrongSpam
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::UrlRblRejected),
            EError::StrongSpam
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::BadKarmaRejected),
            EError::StrongSpam
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::MailLimitsRejected),
            EError::StrongSpam
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::PddAdminKarmaRejected),
            EError::StrongSpam
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::BouncesRejected),
            EError::StrongSpam
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::SpamComplRejected),
            EError::StrongSpam
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::RelayNotSet),
            EError::SendMessageFailed
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::CycleDetected),
            EError::SendMessageFailed
        )
    )
);

} // namespace anonymous
