#include <mail/nwsmtp/src/web/send_mail/error_code.h>
#include <mail/nwsmtp/src/web/send_mail/make_response.h>
#include <mail/nwsmtp/src/web/send_mail/response.h>

#include <boost/fusion/include/equal_to.hpp>

#include <gtest/gtest.h>
#include <gmock/gmock.h>

namespace NNwSmtp::NWeb::NSendMail {

static bool operator ==(const TResponse& lhs, const TResponse& rhs) {
    return boost::fusion::operator==(lhs, rhs);
}

}

namespace {

using namespace testing;
using namespace NNwSmtp;
using namespace NNwSmtp::NWeb::NSendMail;
using EError = NWeb::NSendMail::EError;

struct TestMakeResponse: TestWithParam<std::tuple<TErrorCode, TResponse>> {
};

TEST_P(TestMakeResponse, test_make_response) {
    EXPECT_EQ(
        MakeResponse(std::get<0>(GetParam())),
        std::get<1>(GetParam())
    );
}

INSTANTIATE_TEST_SUITE_P(
    test_make_response,
    TestMakeResponse,
    Values(
        std::make_tuple(
            make_error_code(EError::Spam),
            TResponse {"Spam", "Trying to send a spam email", {}}
        ),
        std::make_tuple(
            make_error_code(EError::StrongSpam),
            TResponse {"StrongSpam", "Trying to send a strong spam email", {}}
        ),
        std::make_tuple(
            make_error_code(EError::Virus),
            TResponse {"Virus", "Trying to send a virus email", {}}
        ),
        std::make_tuple(
            make_error_code(EError::BadRecipient),
            TResponse {"BadRecipient", "Bad recipient", {}}
        ),
        std::make_tuple(
            make_error_code(EError::ReadOnlyMailList),
            TResponse {"BadRecipient", "Maillist is readonly", {}}
        ),
        std::make_tuple(
            make_error_code(EError::MailListWriteProhibited),
            TResponse {"BadRecipient", "External user can't write to internal list", {}}
        ),
        std::make_tuple(
            make_error_code(EError::TempBanUser),
            TResponse {"BadKarmaBanTime", "Temporary ban user", {}}
        ),
        std::make_tuple(
            make_error_code(EError::BadKarma),
            TResponse {"BadKarmaBanTime", "User has bad karma", {}}
        ),
        std::make_tuple(
            make_error_code(EError::SendMessageFailed),
            TResponse {"SendMessageFailed", "Send message failed", {}}
        ),
        std::make_tuple(
            make_error_code(EError::FailedToAuthSender),
            TResponse {"FailedToAuthSender", "Failed to authorize the sender", {}}
        ),
        std::make_tuple(
            make_error_code(EError::PathToLong),
            TResponse {"BadSender", "Path too long", {}}
        ),
        std::make_tuple(
            make_error_code(EError::BadAddressSyntax),
            TResponse {"BadSender", "Bad address mailbox syntax", {}}
        ),
        std::make_tuple(
            make_error_code(EError::BadSender),
            TResponse {"BadSender", "Bad sender", {}}
        ),
        std::make_tuple(
            make_error_code(EError::ToManyRecipients),
            TResponse {"ToManyRecipients", "Too many recipients", {}}
        ),
        std::make_tuple(
            make_error_code(EError::Exception),
            TResponse {"", "Exception", {}}
        ),
        std::make_tuple(
            make_error_code(EError::SendMessageTempFail),
            TResponse {"", "Send message temporarily failed", {}}
        ),
        std::make_tuple(
            make_error_code(EError::MLNotFound),
            TResponse {"", "Mail list not found", {}}
        )
    )
);

} // namespace anonymous
