#pragma once

#include <gmock/gmock.h>
#include <gtest/gtest.h>

#include <mail/nwsmtp/src/big_ml/client.h>
#include <mail/nwsmtp/src/blackbox/bb_checks.h>
#include <mail/nwsmtp/src/delivery/async/interface.h>
#include <mail/nwsmtp/src/ml/client.h>
#include <mail/nwsmtp/src/router/dns_router.h>
#include <mail/nwsmtp/src/router/router.h>

namespace NNwSmtp::NWeb::NSendMail::NTest {

struct TRouterClientMock: Router {
    MOCK_METHOD(void, asyncRoute, (TContextPtr, const std::string&, RouterCall::Handler));
};

struct TBBChecksMock: NBlackBox::IBBChecks {
    MOCK_METHOD(void, CheckRecipient,
        (TContextPtr, std::string, std::string, bool, bool, TCallback)
    );
    MOCK_METHOD(void, CheckMailFrom,
        (TContextPtr, std::string, std::string, TCallback)
    );
    MOCK_METHOD(void, CheckAuth,
        (TContextPtr, TAuthData authInfo, TCallback)
    );
};

struct TBigMLMock: NBigML::IClient {
    MOCK_METHOD(void, Run,
        (TContextPtr, NBigML::TRequest, TCallback)
    );
};

struct TMLMock: NML::IClient {
    MOCK_METHOD(void, Run,
        (TContextPtr, NML::TRequest, TCallback)
    );
};

struct TDeliveryMock: NAsyncDlv::IAsyncDelivery {
    MOCK_METHOD(void, Run,
        (TContextPtr, NAsyncDlv::TRequest, NAsyncDlv::TCallback)
    );
};

} // namespace NNwSmtp::NWeb::NSendMail::NTest
