#include <mail/nwsmtp/src/so/types.h>
#include <mail/nwsmtp/src/so/utils.h>

#include <gtest/gtest.h>
#include <gmock/gmock.h>

using namespace testing;
using namespace NNwSmtp;
using namespace NNwSmtp::NSO;

namespace {

struct TTestResolutionToString: TestWithParam<std::tuple<EResolution, std::string>> {
};

TEST_P(TTestResolutionToString, test_resolution_to_string) {
    EXPECT_EQ(
        ResolutionToString(std::get<0>(GetParam())),
        std::get<1>(GetParam())
    );
}

INSTANTIATE_TEST_SUITE_P(
    test_resolution_to_string,
    TTestResolutionToString,
    Values(
        std::make_tuple(
            EResolution::SO_RESOLUTION_ACCEPT,
            "1"
        ),
        std::make_tuple(
            EResolution::SO_RESOLUTION_SPAM,
            "4"
        ),
        std::make_tuple(
            EResolution::SO_RESOLUTION_REJECT,
            "256"
        ),
        std::make_tuple(
            EResolution::SO_RESOLUTION_INVALID,
            "-1"
        ),
        std::make_tuple(
            EResolution::SO_RESOLUTION_SKIP,
            "0"
        )
    )
);

struct TTestReport: TestWithParam<std::tuple<EResolution, std::string>> {
};

TEST_P(TTestReport, test_report) {
    EXPECT_EQ(
        Report(std::get<0>(GetParam())),
        std::get<1>(GetParam())
    );
}

INSTANTIATE_TEST_SUITE_P(
    test_report,
    TTestReport,
    Values(
        std::make_tuple(
            EResolution::SO_RESOLUTION_ACCEPT,
            "accept"
        ),
        std::make_tuple(
            EResolution::SO_RESOLUTION_SPAM,
            "spam"
        ),
        std::make_tuple(
            EResolution::SO_RESOLUTION_REJECT,
            "reject"
        ),
        std::make_tuple(
            EResolution::SO_RESOLUTION_INVALID,
            "error"
        ),
        std::make_tuple(
            EResolution::SO_RESOLUTION_SKIP,
            "error"
        )
    )
);

struct TTestResolutionFromString: TestWithParam<std::tuple<std::string, EResolution>> {
};

TEST_P(TTestResolutionFromString, test_resolution_from_string) {
    EXPECT_EQ(
        ResolutionFromString(std::get<0>(GetParam())),
        std::get<1>(GetParam())
    );
}

INSTANTIATE_TEST_SUITE_P(
    test_resolution_from_string,
    TTestResolutionFromString,
    Values(
        std::make_tuple(
            "1",
            EResolution::SO_RESOLUTION_ACCEPT
        ),
        std::make_tuple(
            "4",
            EResolution::SO_RESOLUTION_SPAM
        ),
        std::make_tuple(
            "256",
            EResolution::SO_RESOLUTION_REJECT
        ),
        std::make_tuple(
            "-1",
            EResolution::SO_RESOLUTION_INVALID
        ),
        std::make_tuple(
            "0",
            EResolution::SO_RESOLUTION_SKIP
        )
    )
);

} // namespace anonymous
