#pragma once

#include <gmock/gmock.h>

#include <spf/aspf.h>

static bool operator == (const spf_parameters& lhs, const spf_parameters& rhs) {
    return lhs.ip == rhs.ip
        && lhs.domain == rhs.domain
        && lhs.from == rhs.from;
}

namespace NNwSmtp::NSPF::NTest {

struct TSPFClientMock: spf_check_interface {
    MOCK_METHOD(void , start,
        (boost::asio::io_service&, const spf_parameters&, const resolver_options&, callback_t, int));
    MOCK_METHOD(void , stop, ());
    MOCK_METHOD(bool , is_inprogress, (), (const));
};

struct TSPFClientMockHolder {
    TSPFClientMock* Mock;
};

TSPFClientMockHolder SPFClientMockHolder;

struct TSPFClientMockImpl {
    void  start(
        boost::asio::io_service& io,
        const spf_parameters& params,
        const resolver_options& options,
        TSPFClientMock::callback_t callback
    ) {
        SPFClientMockHolder.Mock->start(io, params, options, callback, 0);
    }

    void  stop() {
        SPFClientMockHolder.Mock->stop();
    }

    bool is_inprogress() const {
        return SPFClientMockHolder.Mock->is_inprogress();
    }
};

}
