#include <mail/nwsmtp/src/delivery/sync/errors.h>
#include <mail/nwsmtp/src/web/sync_response.h>
#include <mail/nwsmtp/src/web/types.h>
#include <mail/nwsmtp/src/types.h>

#include <gtest/gtest.h>
#include <gmock/gmock.h>

namespace {

using namespace testing;
using namespace NNwSmtp;
using namespace NDlv;
using namespace NWeb;
using namespace NSync;
using EHttpCode::bad_request;
using EHttpCode::internal_server_error;
using EHttpCode::conflict;
using EHttpCode::not_acceptable;

struct TTestToErrorCode: TestWithParam<std::tuple<TErrorCode, std::string>> {
};

TEST_P(TTestToErrorCode, test_to_error_code) {
    EXPECT_EQ(
        ToErrorCode(std::get<0>(GetParam())),
        std::get<1>(GetParam())
    );
}

INSTANTIATE_TEST_SUITE_P(
    test_to_error_code,
    TTestToErrorCode,
    Values(
        std::make_tuple(
            make_error_code(EError::BadMessage),
            "bad_request"
        ),
        std::make_tuple(
            make_error_code(EError::NslsPermanentError),
            "store_error"
        ),
        std::make_tuple(
            make_error_code(EError::NslsTemporaryError),
            "store_error"
        ),
        std::make_tuple(
            make_error_code(EError::DuplicateFound),
            "duplicate_found"
        ),
        std::make_tuple(
            make_error_code(EError::Exception),
            "internal_server_error"
        ),
        std::make_tuple(
            make_error_code(EError::MdsError),
            "internal_server_error"
        ),
        std::make_tuple(
            make_error_code(EError::StorageMailNotFound),
            "internal_server_error"
        ),
        std::make_tuple(
            make_error_code(EError::SOError),
            "internal_server_error"
        ),
        std::make_tuple(
            make_error_code(EError::AvirError),
            "internal_server_error"
        ),
        std::make_tuple(
            make_error_code(EError::Virus),
            "rejected_virus"
        ),
        std::make_tuple(
            make_error_code(EError::Spam),
            "rejected_spam"
        ),
        std::make_tuple(
            make_error_code(EError::Malicious),
            "rejected_spam"
        ),
        std::make_tuple(
            make_error_code(EError::InvalidFid),
            "store_error"
        ),
        std::make_tuple(
            make_error_code(EError::CycleDetected),
            "loop_detected"
        )
    )
);

struct TTestToHttpStatus: TestWithParam<std::tuple<TErrorCode, EHttpCode>> {
};

TEST_P(TTestToHttpStatus, test_to_http_status) {
    EXPECT_EQ(
        ToHttpStatus(std::get<0>(GetParam())),
        std::get<1>(GetParam())
    );
}

INSTANTIATE_TEST_SUITE_P(
    test_to_http_status,
    TTestToHttpStatus,
    Values(
        std::make_tuple(
            make_error_code(EError::BadMessage),
            bad_request
        ),
        std::make_tuple(
            make_error_code(EError::NslsPermanentError),
            conflict
        ),
        std::make_tuple(
            make_error_code(EError::NslsTemporaryError),
            internal_server_error
        ),
        std::make_tuple(
            make_error_code(EError::DuplicateFound),
            conflict
        ),
        std::make_tuple(
            make_error_code(EError::Exception),
            internal_server_error
        ),
        std::make_tuple(
            make_error_code(EError::MdsError),
            internal_server_error
        ),
        std::make_tuple(
            make_error_code(EError::StorageMailNotFound),
            internal_server_error
        ),
        std::make_tuple(
            make_error_code(EError::SOError),
            internal_server_error
        ),
        std::make_tuple(
            make_error_code(EError::AvirError),
            internal_server_error
        ),
        std::make_tuple(
            make_error_code(EError::Virus),
            not_acceptable
        ),
        std::make_tuple(
            make_error_code(EError::Spam),
            not_acceptable
        ),
        std::make_tuple(
            make_error_code(EError::Malicious),
            not_acceptable
        ),
        std::make_tuple(
            make_error_code(EError::InvalidFid),
            conflict
        )
    )
);

} // namespace anonymous
