#pragma once

#include <gmock/gmock.h>
#include <gtest/gtest.h>

#include <mail/nwsmtp/src/blackbox/bb_checks.h>
#include <mail/nwsmtp/src/types.h>
#include <mail/nwsmtp/src/bb_result.h>

namespace NNwSmtp::NBlackBox::NTest {

using Callback = std::function<void (TErrorCode, NBlackBox::TResponse)>;

struct TBBChecksMock : NBlackBox::IBBChecks {
    MOCK_METHOD(void, CheckRecipient, (TContextPtr, std::string, std::string, bool, bool, IBBChecks::TCallback), (override));
    MOCK_METHOD(void, CheckMailFrom, (TContextPtr, std::string, std::string, IBBChecks::TCallback), (override));
    MOCK_METHOD(void, CheckAuth, (TContextPtr, TAuthData authInfo, Callback), (override));
};

}
