#include "utils.h"
#include <iostream>

#include <library/cpp/resource/resource.h>
#include <util/generic/algorithm.h>
#include <util/random/random.h>
#include <mail/nwsmtp/src/utils.h>

namespace NTesting {

std::vector<size_t> MakeRandomSlices(size_t upperBound, size_t count) {
    if (upperBound < count + 1) {
        throw std::logic_error("Not enough range for slice count");
    }
    std::vector<size_t> slices{0, upperBound};
    while (slices.size() != count + 1) {
        auto bound = RandomNumber(upperBound);
        auto iter = std::lower_bound(slices.begin(), slices.end(), bound);
        if (iter == slices.end() || *iter != bound) {
            slices.emplace(iter, bound);
        }
    }
    return slices;
}

NNwSmtp::TBuffer LoadMessageAsBuffer(const std::string& key, size_t chunks_at_least) {
    if (chunks_at_least < 1) {
        throw std::logic_error("Chunk count < 1 is not allowed");
    }

    const auto& msg = NResource::Find(key);
    auto slices = MakeRandomSlices(msg.size(), chunks_at_least);

    NNwSmtp::TBuffer buffer;
    for (size_t i = 1; i < slices.size(); ++i) {
        std::string slice{
            msg.data() + slices[i - 1],
            msg.data() + slices[i]};
        buffer.append(NNwSmtp::NUtil::MakeSegment(slice));
    }

    return buffer;
}

}  // namespace NTesting
