#pragma once

#include <util/random/random.h>

#include <mail/nwsmtp/src/types.h>

#include <string>

namespace NTesting {

template <typename TIterator>
class TGenerator {
public:
    explicit TGenerator(const boost::iterator_range<TIterator>& range)
        : Range(range)
    {}

    auto operator()() const {
        return *(Range.begin() + RandomNumber(Range.size()));
    }

private:
    const boost::iterator_range<TIterator> Range;
};

template <typename TIterator>
TGenerator<TIterator> MakeGenerator(const boost::iterator_range<TIterator>& range) {
    return TGenerator<TIterator>(range);
}

NNwSmtp::TBuffer LoadMessageAsBuffer(const std::string& key, size_t chunks_at_least = 1);

}  // namespace NTesting
