#include <mail/nwsmtp/src/utils.h>

#include <yplatform/encoding/base64.h>

#include <gtest/gtest.h>

namespace {

using NNwSmtp::NUtil::IsCheckSenderInRcpts;

TEST(TestGetTimestamp, for_get_timestamp_should_return_timestamp_with_length_14) {
    EXPECT_EQ(GetTimestamp().size(), 14u);
}

TEST(TestIpToBytes, for_string_with_ipv6_should_return_string_with_byte_representation_of_ip) {
    EXPECT_EQ(
        yplatform::base64_encode_str(IpToBytes("2a02:6b8:c0c:198f:0:640:39d5:f290")),
        "KgIGuAwMGY8AAAZAOdXykA=="
    );
}

TEST(TestIpToBytes, for_string_with_ipv4_should_return_string_with_byte_representation_of_ip) {
    EXPECT_EQ(
        yplatform::base64_encode_str(IpToBytes("192.0.2.235")),
        "wAAC6w=="
    );
}

TEST(TestIpToBytes, for_string_with_bad_ip_should_return_empty_string) {
    EXPECT_EQ(
        yplatform::base64_encode_str(IpToBytes("ip")),
        ""
    );
}

TEST(TestIsASCII, for_string_with_not_ascii_char_should_return_false) {
    EXPECT_FALSE(IsASCII("Holla\xdf!"));
}

TEST(TestIsASCII, for_string_with_only_ascii_chars_should_return_true) {
    EXPECT_TRUE(IsASCII("Holla!"));
}

TEST(TestIsCheckSenderInRcpts, for_delivery_to_sender_control_off_and_empty_sender_uid_must_return_false) {
    EXPECT_FALSE(IsCheckSenderInRcpts({}, {}));
}

TEST(TestIsCheckSenderInRcpts, for_delivery_to_sender_control_off_and_nonempty_sender_uid_must_return_false) {
    const std::string uid{"UID"};
    EXPECT_FALSE(IsCheckSenderInRcpts({}, uid));
}

TEST(TestIsCheckSenderInRcpts, for_delivery_to_sender_control_on_and_empty_sender_uid_must_return_false) {
    const auto useDeliveryToSenderControl{true};
    EXPECT_FALSE(IsCheckSenderInRcpts(useDeliveryToSenderControl, {}));
}

TEST(TestIsCheckSenderInRcpts, for_delivery_to_sender_control_on_and_nonempty_sender_uid_must_return_true) {
    const auto useDeliveryToSenderControl{true};
    const std::string uid{"UID"};
    EXPECT_TRUE(IsCheckSenderInRcpts(useDeliveryToSenderControl, uid));
}

} // namespace anonymous
