#include <mail/nwsmtp/src/web/utils/get_param.h>

#include <gtest/gtest.h>
#include <gmock/gmock.h>

using namespace testing;
using namespace NNwSmtp::NWeb;

namespace {

TEST(GetVectorParam, for_existing_url_vector_parameter_should_return_vector_of_its_values) {
    EXPECT_THAT(
        GetVectorParam({{"to", "peppa@pig.com"}, {"to", "george@pig.com"}, {"lid", "lid2"}}, "to"),
        ElementsAre("peppa@pig.com", "george@pig.com")
    );
}

TEST(GetVectorParam, for_none_existing_url_vector_parameter_should_throw_exception) {
    EXPECT_THROW(
        GetVectorParam({{"lid", "lid2"}}, "who"),
        std::invalid_argument
    );
}

TEST(GetVectorParam, for_none_existing_optional_url_vector_parameter_should_return_default_value) {
    EXPECT_TRUE(GetVectorParam({{"lid", "lid2"}}, "who", {}).empty());
}

TEST(GetParamTest, for_none_existing_optional_url_parameter_should_return_default_value) {
    EXPECT_TRUE(GetParam({{"lid", "lid2"}}, "who", {}).empty());
}

TEST(GetParamTest, for_existing_optional_url_parameter_should_return_it_value) {
    EXPECT_EQ(GetParam({{"lid", "lid2"}}, "lid", {}), "lid2");
}

} // namespace anonymous
