#include <mail/nwsmtp/src/web/utils/message_transforms.h>
#include <mail/nwsmtp/src/utils.h>
#include <mail/nwsmtp/src/web/send_mail/utils.h>

#include <boost/range/algorithm.hpp>

#include <gtest/gtest.h>
#include <gmock/gmock.h>

namespace {

using namespace testing;
using namespace NNwSmtp::NUtil;
using namespace NNwSmtp::NWeb;

struct TTestAddEndingCrlf: TestWithParam<std::tuple<std::string, std::string, std::size_t>> {
};

TEST_P(TTestAddEndingCrlf, test_add_crlf) {
    auto resultStr = std::get<0>(GetParam());
    AddEndingCRLF(resultStr);
    EXPECT_EQ(std::get<2>(GetParam()), resultStr.size());
    EXPECT_EQ(std::get<1>(GetParam()), resultStr);
}	

INSTANTIATE_TEST_SUITE_P(
    test_add_ending_crlf,
    TTestAddEndingCrlf,
    Values(
        std::make_tuple(
            "",
            "\r\n",
            2u
        ),
        std::make_tuple(
            "t\n",
            "t\n\r\n",
            4u
        ),
        std::make_tuple(
            "t\r\n",
            "t\r\n",
            3u
        ),
        std::make_tuple(
            "\nt\r",
            "\nt\r\r\n",
            5u
        )
    )
);

struct TTestStoreMessageTransforms: TestWithParam<std::tuple<std::string, std::string, std::size_t>> {
};

TEST_P(TTestStoreMessageTransforms, test_store_message_transforms) {
    auto segment = MakeSegment(std::get<0>(GetParam()));
    auto result = StoreMessageTransforms(segment);
    auto resultStr = boost::copy_range<std::string>(result);
    EXPECT_EQ(std::get<2>(GetParam()), resultStr.size());
    EXPECT_EQ(std::get<1>(GetParam()), resultStr);
}

INSTANTIATE_TEST_SUITE_P(
    test_store_message_transforms,
    TTestStoreMessageTransforms,
    Values(
        std::make_tuple(
            "",
            "",
            0u
        ),
        std::make_tuple(
            "\nt.\n",
            "\nt.\n",
            4u
        ),
        std::make_tuple(
            "..\r\n",
            ".\r\n",
            3u
        ),
        std::make_tuple(
            "\r\n..",
            "\r\n.",
            3u
        ),
        std::make_tuple(
            ". one dot\r\n"
            "... three dots\r\n"
            "without dots\r\n"
            ".\r\r\n\n"
            "..\r\n",
            " one dot\r\n"
            ".. three dots\r\n"
            "without dots\r\n"
            "\r\r\n\n"
            ".\r\n",
            46u
        )
    )
);

} // namespace
