GTEST()

OWNER(
    g:mproto
)

ENV(
    ASAN_OPTIONS=detect_stack_use_after_return=1
)

ADDINCL(
    mail/nwsmtp/src
    mail/nwsmtp/ut
)

PEERDIR(
    contrib/libs/protobuf
    mail/nwsmtp/src
    library/cpp/testing/common
)

SRCS(
    init_log.cpp
    init_config.cpp
    http_client_mock.cpp
    http_cluster_client_test_impl.cpp
    base_http_test.cpp
    utils.cpp
    address_parser_ut.cpp
    avir/avir_client_ut.cpp
    big_ml_client_ut.cpp
    blackbox/bb_checks_ut.cpp
    blackbox/bb_client_ut.cpp
    control_from_ut.cpp
    client_rbl_ut.cpp
    delivery/build_hint_ut.cpp
    delivery/so_ut.cpp
    delivery/sync_delivery_ut.cpp
    delivery/sync_errors_ut.cpp
    delivery/utils_ut.cpp
    dkim/common_domain_depth_ut.cpp
    dkim/signature_parser_ut.cpp
    dkim/dkim_check_ut.cpp
    dkim/dkim_sign_ut.cpp
    dmarc_check_policy_ut.cpp
    dmarc_parse_ut.cpp
    error_code_ut.cpp
    fouras/client_ut.cpp
    header_storage_ut.cpp
    hosts_resolver_ut.cpp
    list_client_parse_ut.cpp
    list_client_ut.cpp
    mailfrom/error_code_ut.cpp
    mailfrom/mailfrom_ut.cpp
    mds/mds_client_test.cpp
    mds/mds_utils_test.cpp
    nsls/client_ut.cpp
    nsls/make_response_ut.cpp
    parse_message_ut.cpp
    recognizer/recognizer_impl_ut.cpp
    resolver/resolver_ut.cpp
    resolver/resolver_client_ut.cpp
    restore/make_args_ut.cpp
    restore/make_response_ut.cpp
    rcpts_ut.cpp
    rcpt_to/error_code_ut.cpp
    rcpt_to/rcpt_to_ut.cpp
    rcpt_to/utils_ut.cpp
    save/make_args_ut.cpp
    save/make_response_ut.cpp
    send_mail/error_code_ut.cpp
    send_mail/send_mail_ut.cpp
    send_mail/make_args_ut.cpp
    send_mail/make_response_ut.cpp
    send_mail/utils_ut.cpp
    settings/settings_client_ut.cpp
    settings_authorization_ut.cpp
    smtp_targeting_ut.cpp
    so/so_client_ut.cpp
    so/utils_ut.cpp
    spf/spf_check_ut.cpp
    spf/spf_client_ut.cpp
    store/make_response_ut.cpp
    web/get_param_ut.cpp
    web/handle_base_ut.cpp
    web/message_transforms_ut.cpp
    web/request_ut.cpp
    utils_ut.cpp
    yarm_client_ut.cpp
    auth_ut.cpp
    xyandexhint_ut.cpp
)

RESOURCE(
    ./data/dkim/mail.private mail.private  # openssl genrsa -out mail.private 1024
    ./data/dkim/for_signing.eml for_signing.eml
    ./data/dkim/pass.eml pass.eml
    ./data/dkim/no_from.eml no_from.eml
    ./data/dkim/no_crlf.eml no_crlf.eml
    ./data/dkim/duplicate_header.eml duplicate_header.eml
    ./data/dkim/reordered_headers.eml reordered_headers.eml
    ./data/dkim/headers_before_signature.eml headers_before_signature.eml
    ./data/dkim/no_txt_record_for_domain.eml no_txt_record_for_domain.eml
    ./data/dkim/modified_body.eml modified_body.eml
    ./data/dkim/non_existent_domain.eml non_existent_domain.eml
    ./data/dkim/modified_signed_header.eml modified_signed_header.eml
    ./data/dkim/modified_not_signed_header.eml modified_not_signed_header.eml
    ./data/dkim/absent_signed_header.eml absent_signed_header.eml
    ./data/dkim/several_signatures.eml several_signatures.eml
    ./data/dkim/several_invalid_signatures.eml several_invalid_signatures.eml
    ./data/dkim/several_neutral_signatures.eml several_neutral_signatures.eml
    ./data/dkim/primary_signature_fail.eml primary_signature_fail.eml
    ./data/dkim/primary_signature_invalid.eml primary_signature_invalid.eml
    ./data/dkim/primary_signature_neutral.eml primary_signature_neutral.eml

    ./data/recipients.json recipients.json
    ./data/delivery_info.json delivery_info.json

    ./data/so/simple_so_request.bin simple_so_request.bin
)

DATA(
    sbr://624010672
    sbr://624017722
    sbr://624022452
)

# To enable dns, until MAILDLV-2359
REQUIREMENTS(network:full)

END()
