from aiohttp import web

from sendr_aiohttp.handler import request_schema, response_schema

from mail.ohio.ohio.api.handlers.base import BaseHandler
from mail.ohio.ohio.api.schemas.base import success_response_schema
from mail.ohio.ohio.api.schemas.path import uid_path_schema
from mail.ohio.ohio.api.schemas.payments import post_payments_order_request_schema
from mail.ohio.ohio.core.actions.order.create_or_update import CreateOrUpdateFromPaymentsOrderAction


class OrderPaymentsHandler(BaseHandler):
    @request_schema(uid_path_schema, location='match_info')
    @request_schema(post_payments_order_request_schema, location='json')
    @response_schema(success_response_schema)
    async def post(self) -> web.Response:
        data = await self.get_data()
        await self.run_action(CreateOrUpdateFromPaymentsOrderAction, **data)
        return self.make_response({})
