from aiohttp import web

from sendr_aiohttp.handler import response_schema

from mail.ohio.ohio.api.handlers.base import BaseHandler
from mail.ohio.ohio.api.schemas.customer import (
    get_customer_services_response_schema
)
from mail.ohio.ohio.core.actions.order.get_all_services import GetAllServicesOrderAction
from mail.ohio.ohio.api.handlers.base import is_globally_disabled


class GetAllServicesHandler(BaseHandler):
    @response_schema(get_customer_services_response_schema)
    async def get(self) -> web.Response:
        data = await self.get_data()
        services = await self.run_action(GetAllServicesOrderAction, **data)
        if is_globally_disabled():
            services=[]
        return self.make_response({
            'data': {
                'services': services,
            },
        })
