from aiohttp import web

from sendr_qstats.http.aiohttp import get_registry_handler

from mail.ohio.ohio.api.handlers.base import BaseHandler
from mail.ohio.ohio.core.actions.ping_db import PingDBAction
from mail.ohio.ohio.utils.stats import REGISTRY


class PingHandler(BaseHandler):
    async def get(self) -> web.Response:
        return web.Response(text='pong')


class PingDBHandler(BaseHandler):
    async def get(self) -> web.Response:
        await self.run_action(PingDBAction)
        return web.Response(text='pong')


UnistatHandler = get_registry_handler(REGISTRY)
