from aiohttp import web

from sendr_aiohttp.handler import request_schema, response_schema

from mail.ohio.ohio.api.schemas.yandex_account import get_customer_yandex_account_orders_query_schema
from mail.ohio.ohio.api.schemas.path import uid_path_schema
from mail.ohio.ohio.core.actions.order.get_yandex_account_for_customer import GetYandexAccountForCustomerOrderAction
from mail.ohio.ohio.api.handlers.customer import BaseCustomerHandler
from mail.ohio.ohio.api.schemas.customer import get_customer_orders_response_schema
from mail.ohio.ohio.api.handlers.base import is_globally_disabled


class CustomerYandexAccountOrdersHandler(BaseCustomerHandler):
    @request_schema(uid_path_schema, location='match_info')
    @request_schema(get_customer_yandex_account_orders_query_schema, location='query')
    @response_schema(get_customer_orders_response_schema)
    async def get(self) -> web.Response:
        data = await self.get_data()
        orders, next_keyset = await self.run_action(GetYandexAccountForCustomerOrderAction, **data)
        if is_globally_disabled():
            orders=[]
        return self.make_response({
            'data': {
                'orders': orders,
                'next': next_keyset,
            }
        })
