from sendr_aiohttp import PrefixedUrl

from mail.ohio.ohio.api.handlers.customer import (
    CustomerOrderByIdHandler, CustomerOrdersHandler, CustomerServicesHandler
)
from mail.ohio.ohio.api.handlers.yandex_account_transactions import CustomerYandexAccountOrdersHandler


class CustomerUrl(PrefixedUrl):
    PREFIX = r'/v1/customer/{customer_uid:\d+}'


CUSTOMER_ROUTES = (
    CustomerUrl(r'/orders', CustomerOrdersHandler, name='v1_customer_orders'),
    CustomerUrl(r'/orders/{order_id:\d+}', CustomerOrderByIdHandler, name='v1_customer_by_id'),
    CustomerUrl(r'/services', CustomerServicesHandler, name='v1_customer_services'),
    CustomerUrl(r'/yandex_account_orders', CustomerYandexAccountOrdersHandler, name='v1_customer_yandex_account_orders'),
)
