from marshmallow import ValidationError, fields, validate, validates_schema

from mail.ohio.ohio.api.schemas.base import BaseSchema, SuccessResponseSchema
from mail.ohio.ohio.api.schemas.order import OrderSchema


class GetCustomerOrdersNextSchema(BaseSchema):
    created_keyset = fields.DateTime()
    order_id_keyset = fields.Integer()


class GetCustomerOrdersQuerySchema(BaseSchema):
    limit = fields.Integer(missing=100, validate=validate.Range(min=0, max=100))
    service_ids = fields.List(fields.Integer())
    subservice_ids = fields.List(fields.String())
    created_keyset = fields.DateTime()
    order_id_keyset = fields.Integer()

    @validates_schema
    def validate_keyset(self, data):
        if ('created_keyset' in data) != ('order_id_keyset' in data):
            raise ValidationError(
                'Fields "created_keyset" and "order_id_keyset" must be passed or not passed together',
                ('created_keyset', 'order_id_keyset'),
            )


class GetCustomerOrdersDataSchema(BaseSchema):
    orders = fields.Nested(OrderSchema, many=True)
    next_ = fields.Nested(GetCustomerOrdersNextSchema, attribute='next', dump_to='next')


class GetCustomerOrdersResponseSchema(SuccessResponseSchema):
    data = fields.Nested(GetCustomerOrdersDataSchema)


class GetCustomerOrderByIdDataSchema(BaseSchema):
    order = fields.Nested(OrderSchema)


class GetCustomerOrderByIdResponseSchema(SuccessResponseSchema):
    data = fields.Nested(GetCustomerOrderByIdDataSchema)


class OrderServiceSchema(BaseSchema):
    service_id = fields.Integer()
    subservice_id = fields.String()


class GetCustomerServicesDataSchema(BaseSchema):
    services = fields.Nested(OrderServiceSchema, many=True)


class GetCustomerServicesResponseSchema(SuccessResponseSchema):
    data = fields.Nested(GetCustomerServicesDataSchema)


get_customer_orders_query_schema = GetCustomerOrdersQuerySchema()
get_customer_orders_response_schema = GetCustomerOrdersResponseSchema()

get_customer_order_by_id_response_schema = GetCustomerOrderByIdResponseSchema()

get_customer_services_response_schema = GetCustomerServicesResponseSchema()
