from marshmallow import fields, post_load
from marshmallow_enum import EnumField

from mail.ohio.ohio.api.schemas.base import BaseSchema
from mail.ohio.ohio.core.entities.order import NDS, Item


class ItemSchema(BaseSchema):
    amount = fields.Decimal(places=2, as_string=True, required=True)
    price = fields.Decimal(places=2, as_string=True, required=True)
    currency = fields.String(required=True)
    nds = EnumField(NDS, by_value=True, required=True)
    name = fields.String(required=True)
    image_path = fields.String(allow_none=True)
    image_url = fields.String(allow_none=True, load_only=True)

    @post_load
    def build_item(self, data):
        return Item(**data)
