from marshmallow import fields, post_dump, post_load
from marshmallow_enum import EnumField

from mail.ohio.ohio.api.schemas.base import BaseSchema
from mail.ohio.ohio.api.schemas.item import ItemSchema
from mail.ohio.ohio.api.schemas.refund import RefundSchema
from mail.ohio.ohio.core.entities.order import OrderData, OrderStatus


class OrderDataSchema(BaseSchema):
    total = fields.Decimal(places=2, as_string=True, required=True)
    currency = fields.String(required=True)
    items = fields.Nested(ItemSchema, many=True, required=True)
    description = fields.String(required=True)
    refunds = fields.Nested(RefundSchema, many=True, required=True)

    @post_load
    def build_order_data(self, data):
        return OrderData(**data)


class OrderSchema(BaseSchema):
    customer_uid = fields.Integer()
    service_id = fields.Integer()
    order_id = fields.Integer()
    subservice_id = fields.String()

    merchant_uid = fields.Integer()
    service_merchant_id = fields.Integer()
    payments_order_id = fields.Integer()

    trust_payment_id = fields.String()
    trust_purchase_token = fields.String()

    status = EnumField(OrderStatus, by_value=True)
    order_data = fields.Nested(OrderDataSchema)
    order_revision = fields.Integer()
    service_data = fields.Dict()
    service_revision = fields.Integer()

    created = fields.DateTime()
    updated = fields.DateTime()

    @post_dump
    def unnest_order_data(self, data):
        order_data = data.pop('order_data') or {}
        return dict(**data, **order_data)  # `dict` instead of brackets to prevent key overrides
