from marshmallow import fields

from mail.ohio.ohio.api.schemas.base import BaseSchema


class UIDPathSchema(BaseSchema):
    customer_uid = fields.Integer(required=True)


class ServiceIDPathSchema(BaseSchema):
    service_id = fields.Integer(required=True)


class UIDAndServicePathSchema(ServiceIDPathSchema):
    customer_uid = fields.Integer(required=True)


class UIDOrderIdPathSchema(UIDPathSchema):
    order_id = fields.Integer(required=True)


uid_path_schema = UIDPathSchema()
uid_and_service_path_schema = UIDAndServicePathSchema()
uid_order_id_path_schema = UIDOrderIdPathSchema()
