from marshmallow import fields
from marshmallow_enum import EnumField

from mail.ohio.ohio.api.schemas.base import BaseSchema
from mail.ohio.ohio.api.schemas.order import OrderDataSchema
from mail.ohio.ohio.core.entities.enums import OrderStatus


class PostPaymentsOrderRequestSchema(BaseSchema):
    payments_service_id = fields.Integer(required=True)  # service identifier
    trust_purchase_token = fields.String(required=True)  # order identifier
    subservice_id = fields.String()

    merchant_uid = fields.Integer(required=True)
    service_merchant_id = fields.Integer(required=True)
    payments_order_id = fields.Integer(required=True)

    status = EnumField(OrderStatus, by_value=True, required=True)

    order_data = fields.Nested(OrderDataSchema, required=True)
    service_data = fields.Dict()
    revision = fields.Integer(required=True)  # order and service revision

    created = fields.DateTime(required=True)


post_payments_order_request_schema = PostPaymentsOrderRequestSchema()
