from marshmallow import fields, post_load
from marshmallow_enum import EnumField

from mail.ohio.ohio.api.schemas.base import BaseSchema
from mail.ohio.ohio.api.schemas.item import ItemSchema
from mail.ohio.ohio.core.entities.order import Refund, RefundStatus


class RefundSchema(BaseSchema):
    trust_refund_id = fields.String()
    refund_status = EnumField(RefundStatus, by_value=True)
    total = fields.Decimal(places=2, as_string=True)
    currency = fields.String(required=True)
    items = fields.Nested(ItemSchema, many=True, exclude=('image_path', 'image_url'))

    @post_load
    def build_refund(self, data):
        return Refund(**data)
