from marshmallow import ValidationError, fields, validate, validates_schema

from mail.ohio.ohio.api.schemas.base import BaseSchema


class GetCustomerYandexAccountOrdersQuerySchema(BaseSchema):
    limit = fields.Integer(missing=100, validate=validate.Range(min=0, max=100))
    created_keyset = fields.DateTime()
    order_id_keyset = fields.Integer()

    @validates_schema
    def validate_keyset(self, data):
        if ('created_keyset' in data) != ('order_id_keyset' in data):
            raise ValidationError(
                'Fields "created_keyset" and "order_id_keyset" must be passed or not passed together',
                ('created_keyset', 'order_id_keyset'),
            )


get_customer_yandex_account_orders_query_schema = GetCustomerYandexAccountOrdersQuerySchema()
