from typing import Optional

import click

from mail.ohio.ohio.core.actions.base import BaseAction
from mail.ohio.ohio.core.entities.service import Service, ServiceType
from mail.ohio.ohio.storage import StorageContext
from mail.ohio.ohio.utils.cli import action_command


@click.command()
@click.option(
    '--type', 'service_type',
    type=click.Choice([st.value for st in ServiceType]),
    default=ServiceType.PAYMENTS.value,
)
@click.option('--tvm-id', type=int, default=None)
@click.option('--trust-service-id', type=str, default=None)
@click.option('--payments-service-id', type=int, default=None)
@click.option('--enabled', type=bool, default=True)
@action_command
async def cli(service_type: ServiceType,
              tvm_id: Optional[int],
              trust_service_id: Optional[str],
              payments_service_id: Optional[int],
              enabled: bool,
              ) -> None:
    db_engine = BaseAction.context.db_engine
    async with StorageContext(db_engine) as storage:
        service = await storage.service.create(Service(
            service_type=service_type,
            tvm_id=tvm_id,
            trust_service_id=trust_service_id,
            payments_service_id=payments_service_id,
            enabled=enabled,
        ))
        print('Created service:', service, sep='\n')
