from sendr_aiopg.action import BaseDBAction as BDBAction
from sendr_core.action import BaseAction as BAction

from mail.ohio.ohio.core.context import CoreContext
from mail.ohio.ohio.interactions import InteractionClients
from mail.ohio.ohio.storage import Storage, StorageContext


class BaseAction(BAction):
    context = CoreContext()

    def __init__(self):
        super().__init__()
        self._clients = InteractionClients(self.logger, self.request_id)

    @property
    def clients(self) -> InteractionClients:
        return self._clients

    async def _run(self):
        with self.logger:
            async with self.clients:
                return await super()._run()


class BaseDBAction(BDBAction, BaseAction):
    storage: Storage
    storage_context_cls = StorageContext
