from typing import List

from sendr_utils import alist

from mail.ohio.ohio.core.actions.base import BaseDBAction
from mail.ohio.ohio.core.entities.order_service import OrderService


class GetAllServicesOrderAction(BaseDBAction):
    """
    Returns services present in the last GET_SERVICES_LIMIT orders of a customer.
    """
    def __init__(self):
        super().__init__()

    async def handle(self) -> List[OrderService]:
        return await alist(self.storage.service.get_all())
