from mail.ohio.ohio.core.actions.base import BaseDBAction
from mail.ohio.ohio.core.entities.order import Order
from mail.ohio.ohio.core.exceptions import OrderNotFoundError
from mail.ohio.ohio.storage.exceptions import OrderNotFoundStorageError


class GetByIdOrderAction(BaseDBAction):
    def __init__(self, customer_uid: int, order_id: int):
        super().__init__()
        self._customer_uid = customer_uid
        self._order_id = order_id

    async def handle(self) -> Order:
        try:
            return await self.storage.order.get(customer_uid=self._customer_uid, order_id=self._order_id)
        except OrderNotFoundStorageError:
            raise OrderNotFoundError
