from typing import List

from sendr_utils import alist

from mail.ohio.ohio.conf import settings
from mail.ohio.ohio.core.actions.base import BaseDBAction
from mail.ohio.ohio.core.entities.order_service import OrderService


class GetServicesOrderAction(BaseDBAction):
    """
    Returns services present in the last GET_SERVICES_LIMIT orders of a customer.
    """
    def __init__(self, customer_uid: int):
        super().__init__()
        self._customer_uid = customer_uid

    async def handle(self) -> List[OrderService]:
        return await alist(self.storage.order.get_services(self._customer_uid, limit=settings.GET_SERVICES_LIMIT))
