from enum import Enum, unique


@unique
class ServiceType(Enum):
    PAYMENTS = 'payments'
    TRUST = 'trust'


@unique
class OrderStatus(Enum):
    PAID = 'paid'
    CANCELLED = 'cancelled'
    REFUNDED = 'refunded'


@unique
class RefundStatus(Enum):
    CREATED = 'created'
    COMPLETED = 'completed'
    FAILED = 'failed'
    REQUESTED = 'requested'


@unique
class NDS(Enum):
    NDS_UNKNOWN = ''
    NDS_NONE = 'nds_none'
    NDS_0 = 'nds_0'
    NDS_10 = 'nds_10'
    NDS_18 = 'nds_18'
    NDS_10_110 = 'nds_10_110'
    NDS_18_118 = 'nds_18_118'
    NDS_20 = 'nds_20'
    NDS_20_120 = 'nds_20_120'
