from dataclasses import dataclass, field
from datetime import datetime
from decimal import Decimal
from typing import List, Optional

from mail.ohio.ohio.core.entities.enums import NDS, OrderStatus, RefundStatus


@dataclass
class Item:
    amount: Decimal
    price: Decimal
    currency: str
    nds: NDS
    name: str
    image_url: Optional[str] = None
    image_path: Optional[str] = None


@dataclass
class Refund:
    trust_refund_id: str
    refund_status: RefundStatus
    total: Decimal
    currency: str
    items: List[Item]


@dataclass
class OrderData:
    total: Decimal
    currency: str
    items: List[Item]
    description: str
    refunds: List[Refund] = field(default_factory=list)


@dataclass
class Order:
    customer_uid: int
    service_id: int
    order_id: Optional[int] = None
    subservice_id: Optional[str] = None

    # Payments ids
    merchant_uid: Optional[int] = None
    service_merchant_id: Optional[int] = None
    payments_order_id: Optional[int] = None

    # Trust ids
    trust_payment_id: Optional[str] = None
    trust_purchase_token: Optional[str] = None

    status: Optional[OrderStatus] = None
    order_data: Optional[OrderData] = None
    order_revision: int = 0
    service_data: Optional[dict] = None
    service_revision: int = 0

    created: Optional[datetime] = None
    updated: Optional[datetime] = None
