from dataclasses import dataclass
from datetime import datetime
from typing import Optional

from mail.ohio.ohio.core.entities.enums import ServiceType


@dataclass
class Service:
    service_type: ServiceType
    service_id: Optional[int] = None
    tvm_id: Optional[int] = None
    trust_service_id: Optional[str] = None
    payments_service_id: Optional[int] = None
    enabled: bool = True

    created: Optional[datetime] = None
    updated: Optional[datetime] = None

    def __post_init__(self) -> None:
        if self.service_type is ServiceType.PAYMENTS:
            assert self.payments_service_id is not None, 'Payments service must have payments_service_id.'
        elif self.service_type is ServiceType.TRUST:
            assert self.trust_service_id is not None, 'Trust service must have trust_service_id.'
