import sqlalchemy as sa
from sqlalchemy.dialects.postgresql import JSONB

from sendr_utils import enum_values

from mail.ohio.ohio.core.entities.enums import OrderStatus, ServiceType

metadata = sa.MetaData(schema='ohio')

order_status = sa.Enum(
    OrderStatus, name='order_status', metadata=metadata, values_callable=enum_values
)
service_type = sa.Enum(
    ServiceType, name='service_type', metadata=metadata, values_callable=enum_values
)

services = sa.Table(
    'services', metadata,
    sa.Column('service_id', sa.BigInteger(), primary_key=True, nullable=False),
    sa.Column('service_type', service_type, nullable=False),
    sa.Column('tvm_id', sa.BigInteger(), nullable=True),
    sa.Column('trust_service_id', sa.Text(), nullable=True),
    sa.Column('payments_service_id', sa.BigInteger(), nullable=True),
    sa.Column('enabled', sa.Boolean(), default=True, nullable=False),
    sa.Column('created', sa.DateTime(timezone=True), default=sa.func.now(), nullable=False),
    sa.Column('updated', sa.DateTime(timezone=True), default=sa.func.now(), nullable=False),
)

customers = sa.Table(
    'customers', metadata,
    sa.Column('customer_uid', sa.BigInteger(), primary_key=True, nullable=False),
    sa.Column('next_order_id', sa.BigInteger(), default=1, nullable=False),
    sa.Column('created', sa.DateTime(timezone=True), default=sa.func.now(), nullable=False),
    sa.Column('updated', sa.DateTime(timezone=True), default=sa.func.now(), nullable=False),
)

orders = sa.Table(
    'orders', metadata,
    sa.Column('customer_uid', sa.BigInteger(), primary_key=True, nullable=False),
    sa.Column('order_id', sa.BigInteger(), primary_key=True, nullable=False),
    sa.Column('service_id', sa.BigInteger(), nullable=False),
    sa.Column('subservice_id', sa.Text(), nullable=True),

    sa.Column('merchant_uid', sa.BigInteger(), nullable=True),
    sa.Column('service_merchant_id', sa.BigInteger(), nullable=True),
    sa.Column('payments_order_id', sa.BigInteger(), nullable=True),

    sa.Column('trust_payment_id', sa.Text(), nullable=True),
    sa.Column('trust_purchase_token', sa.Text(), nullable=True),

    sa.Column('status', order_status, nullable=True),
    sa.Column('order_data', JSONB(), nullable=True),
    sa.Column('order_revision', sa.BigInteger(), default=0, nullable=False),
    sa.Column('service_data', JSONB(), nullable=True),
    sa.Column('service_revision', sa.BigInteger(), default=0, nullable=False),

    sa.Column('created', sa.DateTime(timezone=True), default=sa.func.now(), nullable=False),
    sa.Column('updated', sa.DateTime(timezone=True), default=sa.func.now(), nullable=False),
)
