from sendr_aiopg import BaseMapper, CRUDQueries
from sendr_aiopg.data_mapper import SelectableDataMapper, TableDataDumper
from sendr_utils import utcnow

from mail.ohio.ohio.core.entities.change_log import ChangeLog
from mail.ohio.ohio.storage.db.tables import change_log as t_change_log
from mail.ohio.ohio.storage.mappers.customer import CustomerSerialMixin
from mail.ohio.ohio.utils.json import json_value_recursive


class ChangeLogDataMapper(SelectableDataMapper):
    selectable = t_change_log
    entity_class = ChangeLog


class ChangeLogDataDumper(TableDataDumper):
    table = t_change_log
    entity_class = ChangeLog

    def dump_data(self, data: dict) -> dict:
        return json_value_recursive(data)


class ChangeLogMapper(CustomerSerialMixin, BaseMapper):
    _builder = CRUDQueries(
        base=t_change_log,
        id_fields=('customer_uid', 'change_log_id'),
        mapper_cls=ChangeLogDataMapper,
        dumper_cls=ChangeLogDataDumper,
    )

    async def create(self, obj: ChangeLog) -> ChangeLog:
        async with self.conn.begin():
            obj.created = obj.updated = utcnow()
            obj.change_log_id = await self.acquire_next_change_log_id(obj.customer_uid)
            query, mapper = self._builder.insert(obj)
            return mapper(await self._query_one(query))
