import asyncio
import logging
import uuid

from sendr_qlog import LoggerContext

from mail.ohio.ohio.conf import settings
from mail.ohio.ohio.core.actions.base import BaseAction
from mail.ohio.ohio.interactions import InteractionClients
from mail.ohio.ohio.interactions.base import BaseInteractionClient, create_connector
from mail.ohio.ohio.storage import Storage
from mail.ohio.ohio.utils.db import create_configured_engine


def create_shell_context():
    loop = asyncio.get_event_loop()

    BaseInteractionClient.CONNECTOR = create_connector()
    request_id = 'manual_' + uuid.uuid4().hex
    logger = LoggerContext(logging.getLogger(), {'request_id': request_id})
    clients = InteractionClients(logger, request_id)

    db_engine = create_configured_engine(loop)

    conn = loop.run_until_complete(db_engine.acquire().__aenter__())
    storage = Storage(conn)

    BaseAction.context.logger = logger
    BaseAction.context.request_id = request_id
    BaseAction.context.db_engine = db_engine

    return {
        'clients': clients,
        'db_engine': db_engine,
        'logger': logger,
        'request_id': request_id,
        'settings': settings,
        'storage': storage,
    }


def action_command(func):
    def _inner(**kwargs):
        create_shell_context()
        loop = asyncio.get_event_loop()
        try:
            return loop.run_until_complete(func(**kwargs))
        finally:
            loop.run_until_complete(BaseInteractionClient.close_connector())

    return _inner
