from dataclasses import asdict, is_dataclass
from typing import Any

from sendr_utils import json_value


def json_value_recursive(obj: Any) -> Any:
    if is_dataclass(obj):
        obj = asdict(obj)

    if isinstance(obj, dict):
        return {k: json_value_recursive(v) for k, v in obj.items()}
    elif isinstance(obj, list):
        return [json_value_recursive(v) for v in obj]
    else:
        return json_value(obj)
