OWNER(g:order-history)

PY3_LIBRARY()

PEERDIR(
    contrib/python/aiosocksy
    contrib/python/marshmallow-enum/py2
    contrib/python/uvloop
    library/python/resource
    mail/python/sendr-qtools
)

PY_SRCS(
    __init__.py
    api/app.py
    api/exceptions.py
    api/handlers/base.py
    api/handlers/customer.py
    api/handlers/payments.py
    api/handlers/utility.py
    api/handlers/trust.py
    api/handlers/services.py
    api/handlers/yandex_account_transactions.py
    api/middlewares.py
    api/routes/customer.py
    api/routes/internal.py
    api/routes/utility.py
    api/routes/service.py
    api/routes/services.py
    api/schemas/base.py
    api/schemas/customer.py
    api/schemas/item.py
    api/schemas/order.py
    api/schemas/path.py
    api/schemas/payments.py
    api/schemas/refund.py
    api/schemas/trust.py
    api/schemas/yandex_account.py
    commands/create_service.py
    commands/pg_pinger_env.py
    commands/runserver.py
    conf.py
    core/actions/base.py
    core/actions/order/base.py
    core/actions/order/create_or_update.py
    core/actions/order/create_or_update_trust.py
    core/actions/order/get_by_id.py
    core/actions/order/get_for_customer.py
    core/actions/order/get_services.py
    core/actions/order/get_yandex_account_for_customer.py
    core/actions/order/get_all_services.py
    core/actions/ping_db.py
    core/context.py
    core/entities/customer.py
    core/entities/enums.py
    core/entities/order.py
    core/entities/order_service.py
    core/entities/service.py
    core/exceptions.py
    interactions/__init__.py
    interactions/base.py
    manage.py
    storage/__init__.py
    storage/db/tables.py
    storage/exceptions.py
    storage/mappers/base.py
    storage/mappers/customer.py
    storage/mappers/order.py
    storage/mappers/service.py
    storage/mappers/utils.py
    utils/cli.py
    utils/db.py
    utils/json.py
    utils/logging.py
    utils/stats.py
    utils/tvm.py
)

RESOURCE_FILES(
    settings/000-logging.conf
    settings/000-logging.conf.production
    settings/010-common.conf
    settings/010-common.conf.production
    settings/020-database.conf
    settings/020-database.conf.development
    settings/020-database.conf.testing
    settings/030-interactions.conf
    settings/040-tvm.conf
    settings/040-tvm.conf.development
    settings/040-tvm.conf.production
    settings/040-tvm.conf.testing
)

END()

RECURSE_FOR_TESTS(tests)
