package ru.yandex.ohio.backend;

import java.util.Objects;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.ServiceUnavailableException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.FakeAsyncConsumer;
import ru.yandex.http.util.nio.StatusCheckFallbackAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonNull;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.JsonString;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;

public abstract class CashbackBalanceHandlerBase
    implements HttpAsyncRequestHandler<HttpRequest>
{
    protected final OhioBackend server;

    protected CashbackBalanceHandlerBase(final OhioBackend server) {
        this.server = server;
    }

    @Override
    public FakeAsyncConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new FakeAsyncConsumer<>(request);
    }

    protected void handle(final ProxySession session, final long uid)
        throws HttpException
    {
        AsyncClient client =
            server.dyngoClient().adjust(session.context());
        client.execute(
            server.dyngoHost(),
            new BasicAsyncRequestProducerGenerator(
                "/ya/user/" + uid + "/balance"),
            new StatusCheckFallbackAsyncResponseConsumerFactory<>(
                x -> x == HttpStatus.SC_NO_CONTENT,
                JsonAsyncTypesafeDomConsumerFactory.ANY_GOOD,
                JsonNull.INSTANCE),
            session.listener().createContextGeneratorFor(client),
            new Callback(
                session,
                JsonTypeExtractor.NORMAL.extract(session.params())));
    }

    private static class Callback
        extends AbstractProxySessionCallback<JsonObject>
    {
        private final JsonType jsonType;

        Callback(
            final ProxySession session,
            final JsonType jsonType)
        {
            super(session);
            this.jsonType = jsonType;
        }

        @Override
        public void completed(final JsonObject result) {
            try {
                JsonMap map =
                    Objects.requireNonNullElse(
                        result.asMapOrNull(),
                        JsonMap.EMPTY);
                long balance = map.getLong("available", 0L);
                JsonMap root = new JsonMap(BasicContainerFactory.INSTANCE);
                root.put(
                    "amount",
                    new JsonString(
                        Double.toString(balance / 100d)));
                new ResultPrinter(session, jsonType).completed(root);
            } catch (JsonException e) {
                failed(new ServiceUnavailableException(e));
            }
        }
    }
}

