package ru.yandex.ohio.backend;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;

public class DirectYandexAccountOrdersHandler extends ListingHandlerBase {
    public DirectYandexAccountOrdersHandler(final OhioBackend server) {
        super(server);
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        ProxySession session =
            new BasicProxySession(server, exchange, context);
        handle(
            new YandexAccountOrdersListingContext(
                server,
                session,
                session.params().getLong("uid")));
    }
}

