package ru.yandex.ohio.backend;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.FakeAsyncConsumer;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.prefix.LongPrefix;
import ru.yandex.search.proxy.universal.PlainUniversalSearchProxyRequestContext;
import ru.yandex.search.request.util.SearchRequestText;

public class DumpUserDataHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    protected final OhioBackend server;

    protected DumpUserDataHandler(final OhioBackend server) {
        this.server = server;
    }

    @Override
    public FakeAsyncConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new FakeAsyncConsumer<>(request);
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        ProxySession session =
            new BasicProxySession(server, exchange, context);
        long uid = session.params().getLong("uid");
        long newUid = session.params().getLong("new-uid", uid);
        Iterator<String> purchaseTokens =
            session.params().getAllOrNull("purchase_token");
        QueryConstructor query = new QueryConstructor(
            "/search?service=ohio_index&get=*&skip-nulls&prefix=" + uid);
        if (purchaseTokens == null) {
            query.append("text", "uid:" + uid);
        } else {
            StringBuilder sb = new StringBuilder("purchase_token:(");
            boolean empty = true;
            while (purchaseTokens.hasNext()) {
                if (empty) {
                    empty = false;
                } else {
                    sb.append(" OR ");
                }
                sb.append('"');
                sb.append(
                    SearchRequestText.quoteEscape(purchaseTokens.next()));
                sb.append('"');
            }
            sb.append(')');
            query.append("text", new String(sb));
        }
        AsyncClient client = server.searchClient().adjust(session.context());
        server.sequentialRequest(
            session,
            new PlainUniversalSearchProxyRequestContext(
                new User("ohio_index", new LongPrefix(uid)),
                null,
                true,
                client,
                session.logger()),
            new BasicAsyncRequestProducerGenerator(query.toString()),
            null,
            true,
            JsonAsyncTypesafeDomConsumerFactory.OK,
            session.listener().createContextGeneratorFor(client),
            new Callback(session, uid, newUid));
    }

    private static class Callback
        extends AbstractProxySessionCallback<JsonObject>
    {
        private final long uid;
        private final long newUid;
        private final JsonType jsonType;

        Callback(
            final ProxySession session,
            final long uid,
            final long newUid)
            throws BadRequestException
        {
            super(session);
            this.uid = uid;
            this.newUid = newUid;
            jsonType = JsonTypeExtractor.NORMAL.extract(session.params());
        }

        private String fixUid(final String value) {
            return value.replaceAll(
                "\"passport_id\":" + uid,
                "\"passport_id\":" + newUid);
        }

        @Override
        public void completed(final JsonObject result) {
            StringBuilderWriter sbw = new StringBuilderWriter();
            try (JsonWriter writer = jsonType.create(sbw)) {
                writer.startObject();
                writer.key("prefix");
                writer.value(newUid);
                writer.key("docs");
                writer.startArray();
                for (JsonObject hitObject: result.get("hitsArray").asList()) {
                    JsonMap hit = hitObject.asMap();
                    writer.startObject();
                    writer.key("uid");
                    writer.value(newUid);
                    for (Map.Entry<String, JsonObject> entry: hit.entrySet()) {
                        String name = entry.getKey();
                        String value = entry.getValue().asString();
                        switch (name) {
                            case "uid":
                                continue;
                            case "rows":
                                value = fixUid(value);
                                break;
                            case "refunds":
                                value = fixUid(value);
                                break;
                        }
                        writer.key(name);
                        writer.value(value);
                    }

                    writer.endObject();
                }
                writer.endArray();
                writer.endObject();
            } catch (IOException | JsonException e) {
                failed(e);
                return;
            }
            session.response(
                HttpStatus.SC_OK,
                new NStringEntity(
                    sbw.toString(),
                    ContentType.APPLICATION_JSON.withCharset(
                        session.acceptedCharset())));
        }
    }
}


