package ru.yandex.ohio.backend;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.logging.Level;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.function.CharArrayProcessable;
import ru.yandex.function.CharArrayReaderFactory;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.nio.AsyncCharArrayProcessableConsumerFactory;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.FakeAsyncConsumer;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonLong;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.parser.searchmap.User;
import ru.yandex.search.prefix.LongPrefix;
import ru.yandex.search.proxy.universal.PlainUniversalSearchProxyRequestContext;

public abstract class FamilypayUsersHandlerBase
    implements HttpAsyncRequestHandler<HttpRequest>
{
    protected final OhioBackend server;

    protected FamilypayUsersHandlerBase(final OhioBackend server) {
        this.server = server;
    }

    @Override
    public FakeAsyncConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new FakeAsyncConsumer<>(request);
    }

    protected void handle(final ProxySession session, final long uid)
        throws HttpException
    {
        AsyncClient client = server.searchClient().adjust(session.context());
        server.parallelRequest(
            session,
            new PlainUniversalSearchProxyRequestContext(
                new User("ohio_index", new LongPrefix(uid)),
                null,
                true,
                client,
                session.logger()),
            new BasicAsyncRequestProducerGenerator(
                "/printkeys?field=initiator_uid&service=ohio_index"
                + "&check-copyness=true&skip-deleted&prefix=" + uid
                + "%23&user=" + uid),
            AsyncCharArrayProcessableConsumerFactory.ANY_GOOD,
            session.listener().createContextGeneratorFor(client),
            new Callback(new ResultPrinter(session), session));
    }

    private static class Callback
        extends AbstractFilterFutureCallback<CharArrayProcessable, JsonObject>
    {
        private final ProxySession session;

        Callback(
            final FutureCallback<JsonObject> callback,
            final ProxySession session)
        {
            super(callback);
            this.session = session;
        }

        @Override
        public void completed(final CharArrayProcessable result) {
            JsonList list = new JsonList(BasicContainerFactory.INSTANCE);
            try (BufferedReader reader =
                    new BufferedReader(
                        result.processWith(CharArrayReaderFactory.INSTANCE)))
            {
                while (true) {
                    String line = reader.readLine();
                    if (line == null) {
                        break;
                    }
                    int idx = line.indexOf('#');
                    if (idx == -1) {
                        session.logger().warning(
                            "Failed to parse line <" + line + '>');
                    } else {
                        String uidString = line.substring(idx + 1);
                        long uid;
                        try {
                            uid = Long.parseLong(uidString);
                        } catch (RuntimeException e) {
                            session.logger().log(
                                Level.WARNING,
                                "Failed to parse line <" + line + '>',
                                e);
                            continue;
                        }
                        JsonMap entry =
                            new JsonMap(BasicContainerFactory.INSTANCE);
                        entry.put("initiator_uid", new JsonLong(uid));
                        list.add(entry);
                    }
                }
            } catch (IOException e) {
                failed(e);
                return;
            }
            JsonMap root = new JsonMap(BasicContainerFactory.INSTANCE);
            root.put("familypay_users", list);
            callback.completed(root);
        }
    }
}

