package ru.yandex.ohio.backend;

import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.HttpResponseSendingCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.BasicAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.FakeAsyncConsumer;
import ru.yandex.http.util.nio.client.AsyncClient;

public abstract class FnsBindingStatusHandlerBase
    implements HttpAsyncRequestHandler<HttpRequest>
{
    protected final OhioBackend server;

    protected FnsBindingStatusHandlerBase(final OhioBackend server) {
        this.server = server;
    }

    @Override
    public FakeAsyncConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new FakeAsyncConsumer<>(request);
    }

    protected void handle(final ProxySession session, final long uid) {
        AsyncClient client =
            server.fnslinkerClient().adjust(session.context());
        client.execute(
            server.fnslinkerHost(),
            new BasicAsyncRequestProducerGenerator(
                "/api/ya/v1/users/" + uid),
            BasicAsyncResponseConsumerFactory.ANY_GOOD,
            session.listener().createContextGeneratorFor(client),
            new HttpResponseSendingCallback(session));
    }
}

