package ru.yandex.ohio.backend;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.NonNegativeIntegerValidator;

public class FnsListingContext {
    protected OhioBackend server;
    protected ProxySession session;
    protected long uid;
    protected int limit;
    protected JsonType jsonType;
    protected int startOffset;
    protected String startUuid;

    public FnsListingContext(
        final OhioBackend server,
        final ProxySession session,
        final long uid)
        throws BadRequestException
    {
        this.server = server;
        this.session = session;
        this.uid = uid;
        limit = session.params().get(
            "limit",
            20,
            NonNegativeIntegerValidator.INSTANCE);
        jsonType = JsonTypeExtractor.NORMAL.extract(session.params());
        Integer startOffset = session.params().get(
            "order_id_keyset",
            null,
            NonNegativeIntegerValidator.INSTANCE);
        if (startOffset == null) {
            this.startOffset = 0;
            startUuid = null;
        } else {
            this.startOffset = startOffset.intValue();
            startUuid = session.params().get(
                "created_keyset",
                NonEmptyValidator.INSTANCE);
        }
    }

    public OhioBackend server() {
        return server;
    }

    public ProxySession session() {
        return session;
    }

    public long uid() {
        return uid;
    }

    public int limit() {
        return limit;
    }

    public JsonType jsonType() {
        return jsonType;
    }

    public int startOffset() {
        return startOffset;
    }

    public String startUuid() {
        return startUuid;
    }
}

