package ru.yandex.ohio.backend;

import java.util.regex.Pattern;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;

public enum ItemAlias {
    BNPL("bnpl", true) {
        @Override
        public boolean testItem(
            final String name,
            final long serviceId,
            final JsonMap orderInfo)
            throws JsonException
        {
            return serviceId == 1125L;
        }
    },
    DONATION("donation", true) {
        @Override
        public boolean testItem(
            final String name,
            final long serviceId,
            final JsonMap orderInfo)
            throws JsonException
        {
            String serviceOrderId = orderInfo.getString("service_order_id", "");
            return serviceOrderId.endsWith("_donation");
        }
    },
    DELIVERY("delivery", true) {
        @Override
        public boolean testItem(
            final String name,
            final long serviceId,
            final JsonMap orderInfo)
            throws JsonException
        {
            if (name.indexOf("Почта России") != -1
                || name.indexOf("СДЕК") != -1)
            {
                return true;
            }
            if (COURIER_PATTERN.matcher(name).find()) {
                return true;
            }
            String serviceProductExternalId =
                orderInfo.getString("service_product_external_id", null);
            if ("BLUE_MARKET_DELIVERY".equals(serviceProductExternalId)) {
                return true;
            }
            String serviceOrderId = orderInfo.getString("service_order_id", "");
            return serviceOrderId.endsWith("_delivery-1");
        }
    },
    SERVICE_FEE("service_fee", true) {
        @Override
        public boolean testItem(
            final String name,
            final long serviceId,
            final JsonMap orderInfo)
            throws JsonException
        {
            if (name.equals("Сервисный сбор")
                || name.equals("Service fee")
                || name.equals("Комиссия"))
            {
                return true;
            }
            String serviceOrderId = orderInfo.getString("service_order_id", "");
            return serviceOrderId.endsWith("_service_fee-1");
        }
    },
    TIP("tip", true) {
        @Override
        public boolean testItem(
            final String name,
            final long serviceId,
            final JsonMap orderInfo)
            throws JsonException
        {
            if (name.equals("Сумма чаевых")) {
                return true;
            }
            String serviceOrderId = orderInfo.getString("service_order_id", "");
            return serviceOrderId.endsWith("_tips");
        }
    },
    TRANSPORTING_FEE("ride", true) {
        @Override
        public boolean testItem(
            final String name,
            final long serviceId,
            final JsonMap orderInfo)
            throws JsonException
        {
            return name.equals("Перевозка пассажиров и багажа")
                || name.equals("Transporting passengers and luggage");
        }
    },
    EXTENDED_SUBSCRIPTION("extended_subscription", false) {
        @Override
        public boolean testItem(
            final String name,
            final long serviceId,
            final JsonMap orderInfo)
            throws JsonException
        {
            return name.equals("Расширенный уровень подписки Яндекс.Плюс")
                || name.equals("Расширенный уровень подписки Яндекс Плюс")
                || name.equals("Extended subscription Yandex Plus");
        }
    },
    TRIP("trip", true) {
        @Override
        public boolean testItem(
            final String name,
            final long serviceId,
            final JsonMap orderInfo)
            throws JsonException
        {
            return name.equals(
                "Арендная плата за аренду транспортного средства");
        }
    },
    TOLL_ROAD("toll-road", true) {
        @Override
        public boolean testItem(
            final String name,
            final long serviceId,
            final JsonMap orderInfo)
            throws JsonException
        {
            return name.equals(
                "Услуга по организации проезда по платной дороге во время "
                + "аренды транспортного средства");
        }
    },
    FINE("fine", true) {
        @Override
        public boolean testItem(
            final String name,
            final long serviceId,
            final JsonMap orderInfo)
            throws JsonException
        {
            return name.equals(
                "Штраф/возмещение убытков по договору аренды транспортного "
                + "средства")
                || FINE_PATTERN.matcher(name).find();
        }
    },
    TOPUP("topup", true) {
        @Override
        public boolean testItem(
            final String name,
            final long serviceId,
            final JsonMap orderInfo)
            throws JsonException
        {
            return name.equals("topup");
        }
    },
    DISK_PRO("disk_pro", false) {
        @Override
        public boolean testItem(
            final String name,
            final long serviceId,
            final JsonMap orderInfo)
            throws JsonException
        {
            return serviceId == 116L
                && name.equals(
                    "Платное предоставление расширенных возможностей сервиса "
                    + "Яндекс.Диск");
        }

        @Override
        public String nameReplacement() {
            return "Тариф \"Диск Про\"";
        }
    },
    TRASH_NAME("trash_name", false) {
        @Override
        public boolean testItem(
            final String name,
            final long serviceId,
            final JsonMap orderInfo)
            throws JsonException
        {
            return name.equals("{product}")
                || name.equals("Оплата заказа")
                || name.equals("Order payment")
                || name.equals("test");
        }

        @Override
        public String nameReplacement() {
            return "none";
        }
    };

    private static final Pattern COURIER_PATTERN =
        Pattern.compile(
            "курьер|доставк[аи]",
            Pattern.CASE_INSENSITIVE
            | Pattern.UNICODE_CASE);
    private static final Pattern FINE_PATTERN =
        Pattern.compile(
            "штраф",
            Pattern.CASE_INSENSITIVE
            | Pattern.UNICODE_CASE);
    private final String aliasName;
    private final boolean export;

    ItemAlias(final String aliasName, final boolean export) {
        this.aliasName = aliasName;
        this.export = export;
    }

    public String aliasName() {
        return aliasName;
    }

    public boolean export() {
        return export;
    }

    public abstract boolean testItem(
        String name,
        long serviceId,
        JsonMap orderInfo)
        throws JsonException;

    public String nameReplacement() {
        return null;
    }
}

