package ru.yandex.ohio.backend;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.server.HttpServer;

public class OrdersHandler extends ListingHandlerBase {
    public OrdersHandler(final OhioBackend server) {
        super(server);
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        ProxySession session =
            new BasicProxySession(server, exchange, context);
        Long uid = (Long) context.getAttribute(HttpServer.TVM_USER_UID);
        session.logger().info("Processing orders request for uid " + uid);
        handle(
            new ListingContext(
                server,
                session,
                uid.longValue()));
    }
}

