package ru.yandex.ohio.backend;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.search.request.util.SearchRequestText;

public class PaymentContext extends ListingContext {
    private final String paymentId;

    public PaymentContext(
        final OhioBackend server,
        final ProxySession session,
        final long uid)
        throws BadRequestException
    {
        super(server, session, uid);
        paymentId = session.params().get(
            "trust_payment_id",
            NonEmptyValidator.TRIMMED);
    }

    @Override
    public String baseQuery() {
        return "(trust_payment_id:\""
            + SearchRequestText.quoteEscape(paymentId)
            + "\" OR trust_group_id:\""
            + SearchRequestText.quoteEscape(paymentId)
            + '"' + ')';
    }
}

