package ru.yandex.ohio.backend;

import java.io.IOException;

import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;

public class ResultPrinter extends AbstractProxySessionCallback<JsonObject> {
    private final JsonType jsonType;

    public ResultPrinter(final ProxySession session)
        throws BadRequestException
    {
        this(session, JsonTypeExtractor.NORMAL.extract(session.params()));
    }

    public ResultPrinter(final ProxySession session, final JsonType jsonType) {
        super(session);
        this.jsonType = jsonType;
    }

    @Override
    public void completed(final JsonObject result) {
        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter writer = jsonType.create(sbw)) {
            writer.startObject();
            writer.key("status");
            writer.value("success");
            writer.key("code");
            writer.value(200);
            writer.key("data");
            result.writeValue(writer);
            writer.endObject();
        } catch (IOException e) {
            failed(e);
            return;
        }
        if (session.debugFlags().contains("log-result")) {
            session.logger().fine(
                "Full request result: " + sbw.toString());
        }

        String requestId =
            session.headers().getOrNull(YandexHeaders.X_REQUEST_ID);
        if (requestId != null) {
            session.getResponse().addHeader(
                YandexHeaders.X_REQUEST_ID,
                requestId);
        }
        session.response(
            HttpStatus.SC_OK,
            new NStringEntity(
                sbw.toString(),
                ContentType.APPLICATION_JSON.withCharset(
                    session.acceptedCharset())));
    }
}

