package ru.yandex.ohio.backend;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.logging.Level;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.function.CharArrayProcessable;
import ru.yandex.function.CharArrayReaderFactory;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.DoubleFutureCallback;
import ru.yandex.http.util.nio.AsyncCharArrayProcessableConsumerFactory;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.FakeAsyncConsumer;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.JsonString;
import ru.yandex.parser.searchmap.User;
import ru.yandex.search.prefix.LongPrefix;
import ru.yandex.search.proxy.SearchResultConsumerFactory;
import ru.yandex.search.proxy.universal.PlainUniversalSearchProxyRequestContext;
import ru.yandex.search.result.SearchResult;

public abstract class ServicesHandlerBase
    implements HttpAsyncRequestHandler<HttpRequest>
{
    protected final OhioBackend server;

    protected ServicesHandlerBase(final OhioBackend server) {
        this.server = server;
    }

    @Override
    public FakeAsyncConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new FakeAsyncConsumer<>(request);
    }

    protected void handle(final ProxySession session, final long uid)
        throws HttpException
    {
        AsyncClient client = server.searchClient().adjust(session.context());
        PlainUniversalSearchProxyRequestContext context =
            new PlainUniversalSearchProxyRequestContext(
                new User("ohio_index", new LongPrefix(uid)),
                null,
                true,
                client,
                session.logger());
        Supplier<? extends HttpClientContext> contextGenerator =
            session.listener().createContextGeneratorFor(client);
        DoubleFutureCallback<Set<String>, Boolean> callback =
            new DoubleFutureCallback<>(
                new Callback(new ResultPrinter(session)));
        server.parallelRequest(
            session,
            context,
            new BasicAsyncRequestProducerGenerator(
                "/printkeys?field=service_id&service=ohio_index"
                + "&check-copyness=true&skip-deleted&prefix=" + uid
                + "%23&user=" + uid),
            AsyncCharArrayProcessableConsumerFactory.ANY_GOOD,
            contextGenerator,
            new ServicesCallback(
                callback.first(),
                session,
                server.terminalsInfos()));
        if (session.params().getBoolean("show-yandexpay", false)) {
            server.parallelRequest(
                session,
                context,
                new BasicAsyncRequestProducerGenerator(
                    "/search?json-type=dollar&service=ohio_index&get=*"
                    + "&length=0&text=source:yandexpay+AND+"
                    + "last_payment_status:(charged+OR+cancelled+OR+captured)"
                    + "&prefix=" + uid),
                SearchResultConsumerFactory.OK,
                contextGenerator,
                new YandexPayCallback(callback.second()));
        } else {
            callback.second().completed(Boolean.FALSE);
        }
    }

    private static class ServicesCallback
        extends AbstractFilterFutureCallback<CharArrayProcessable, Set<String>>
    {
        private final ProxySession session;
        private final TerminalsInfos terminalsInfos;

        ServicesCallback(
            final FutureCallback<? super Set<String>> callback,
            final ProxySession session,
            final TerminalsInfos terminalsInfos)
        {
            super(callback);
            this.session = session;
            this.terminalsInfos = terminalsInfos;
        }

        @Override
        public void completed(final CharArrayProcessable result) {
            try (BufferedReader reader =
                    new BufferedReader(
                        result.processWith(CharArrayReaderFactory.INSTANCE)))
            {
                Set<String> services = new TreeSet<>();
                while (true) {
                    String line = reader.readLine();
                    if (line == null) {
                        break;
                    }
                    int idx = line.indexOf('#');
                    if (idx == -1) {
                        session.logger().warning(
                            "Failed to parse line <" + line + '>');
                    } else {
                        String idString = line.substring(idx + 1);
                        long idValue;
                        try {
                            idValue = Long.parseLong(idString);
                        } catch (RuntimeException e) {
                            session.logger().log(
                                Level.WARNING,
                                "Failed to parse line <" + line + '>',
                                e);
                            continue;
                        }
                        if (terminalsInfos.isKnownService(idValue)) {
                            services.add(idString);
                        } else {
                            session.logger().info(
                                "Unknown service_id " + idValue
                                + ", skipping line <" + line + '>');
                        }
                    }
                }
                callback.completed(services);
            } catch (IOException e) {
                failed(e);
            }
        }
    }

    private static class YandexPayCallback
        extends AbstractFilterFutureCallback<SearchResult, Boolean>
    {
        YandexPayCallback(final FutureCallback<? super Boolean> callback) {
            super(callback);
        }

        @Override
        public void completed(final SearchResult result) {
            if (result.hitsCount() > 0) {
                callback.completed(Boolean.TRUE);
            } else {
                callback.completed(Boolean.FALSE);
            }
        }
    }

    private static class Callback
        extends AbstractFilterFutureCallback
            <Map.Entry<Set<String>, Boolean>, JsonObject>
    {
        Callback(final FutureCallback<? super JsonObject> callback) {
            super(callback);
        }

        @Override
        public void completed(final Map.Entry<Set<String>, Boolean> result) {
            Set<String> services = new TreeSet<>(result.getKey());
            if (result.getValue().booleanValue()) {
                services.add("1042");
            }
            JsonList list = new JsonList(BasicContainerFactory.INSTANCE);
            for (String service: services) {
                JsonMap entry =
                    new JsonMap(BasicContainerFactory.INSTANCE);
                JsonString id = new JsonString(service);
                entry.put("service_id", id);
                entry.put("subservice_id", id);
                list.add(entry);
            }
            JsonMap root = new JsonMap(BasicContainerFactory.INSTANCE);
            root.put("services", list);
            callback.completed(root);
        }
    }
}

