package ru.yandex.ohio.backend;

import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;

public class TerminalInfo {
    private final long terminalId;
    private final long firmId;
    private final long firmRegionId;
    private final long paymentMethodId;
    // may be -1
    private final long serviceId;
    private final String paymentMethodName;

    public TerminalInfo(final JsonObject map) throws JsonException {
        terminalId = map.get("terminal_id").asLong();
        firmId = map.get("firm_id").asLong();
        firmRegionId = map.get("firm_region_id").asLong();
        paymentMethodId = map.get("terminal_payment_method_id").asLong();
        Long serviceId = map.get("service_id").asLongOrNull();
        if (serviceId == null) {
            this.serviceId = -1L;
        } else {
            this.serviceId = serviceId.longValue();
        }
        String paymentMethodName =
            map.get("terminal_payment_method_name").asString();
        int idx = paymentMethodName.indexOf(' ');
        if (idx <= 0) {
            throw new JsonException(
                "Malformed terminal_payment_method_name <"
                + paymentMethodName + '>');
        }
        this.paymentMethodName = paymentMethodName.substring(0, idx);
    }

    public long terminalId() {
        return terminalId;
    }

    public long firmId() {
        return firmId;
    }

    public long firmRegionId() {
        return firmRegionId;
    }

    public long paymentMethodId() {
        return paymentMethodId;
    }

    public long serviceId() {
        return serviceId;
    }

    public String paymentMethodName() {
        return paymentMethodName;
    }
}

